/*
 * Decompiled with CFR 0.152.
 */
package com.hls.Formel;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Formel
extends Applet
implements Runnable {
    Thread thread;
    Font f;
    Color fcol = Color.red;
    Color bcol = Color.blue;
    Color strike_col = new Color(204, 0, 0);
    String body;
    int app_w;
    int app_h;
    int posx = 2;
    int posy = 14;
    FormelGraph fg;
    int first_time = 1;
    String body1 = "E = m*c^2 + m^n + C^2 + a.ij + B.12 + O& + ( 1 2 ) + ( 1_2 ) + 1/2";
    String body2 = "F(x)=Integral x*ln(x) dx";
    String body3 = "1/x + 1/x = 2/x";
    String body4 = "g ( t ) = ( 1 _ 2 ) + t * ( -1 _ 1 )";
    String body5 = "A~> + B~> = C~>";

    public Color ColorCreateHtml(String s) {
        int i = s != null && s.length() == 7 ? Integer.parseInt(s.substring(1), 16) : (int)Math.random() * 256 * 256 * 256;
        return new Color(i);
    }

    public Color ColorCreateHtmlDef(String s, Color def) {
        if (s != null && s.length() == 7) {
            int i = Integer.parseInt(s.substring(1), 16);
            return new Color(i);
        }
        return def;
    }

    public void init() {
        String sg;
        String sart;
        String background = this.getParameter("Hintergrund");
        this.bcol = this.ColorCreateHtmlDef(background, this.ColorCreateHtml("#dddddd"));
        this.setBackground(this.bcol);
        String foreground = this.getParameter("Vordergrund");
        this.fcol = this.ColorCreateHtmlDef(foreground, this.ColorCreateHtml("#000066"));
        this.body = this.getParameter("Body");
        if (this.body == null) {
            this.body = this.body1;
        }
        if ((sart = this.getParameter("Schriftart")) == null) {
            sart = "TimesRoman";
        }
        if ((sg = this.getParameter("Schriftgr\u00f6\u00dfe")) == null) {
            sg = "18";
        }
        int isg = Integer.parseInt(sg);
        this.f = new Font(sart, 0, isg);
    }

    public void paint(Graphics g) {
        Dimension di = this.getSize();
        int w = di.width;
        int h = di.height;
        g.setFont(this.f);
        if (this.first_time > 0 || this.app_w != w || this.app_h != h) {
            this.first_time = 0;
            this.app_w = w;
            this.app_h = h;
            FontMetrics fm = g.getFontMetrics(this.f);
            this.fg = new FormelGraph(this.body, fm);
        }
        g.drawRect(0, 0, w - 1, h - 1);
        Dimension fdi = this.fg.getSize();
        this.posx = (w - fdi.width) / 2;
        this.posy = (h - fdi.height) / 2;
        g.setColor(this.fcol);
        this.fg.paint(g, this.posx, this.posy);
    }

    public void run() {
    }

    public void start() {
    }

    public void stop() {
    }

    class FormelElem {
        String s;
        char type;
        char connect;
        int asc;
        int dsc;
        int w;
        int h;
        int x;
        int y;
        byte strike;
        byte ratio;
        Rectangle rect = new Rectangle();
        Rectangle rect_all = new Rectangle();
        FormelElem parent;
        FormelElem top;
        FormelElem topr;
        FormelElem right;
        FormelElem botr;
        FormelElem bot;

        public FormelElem(String s, char type, char connect, FormelMetrics fom) {
            Formel.this = Formel.this;
            this.s = s;
            this.type = type;
            this.connect = connect;
            this.w = fom.fm.stringWidth(s);
            this.h = fom.h;
            this.asc = fom.asc;
            this.dsc = fom.dsc;
        }

        public void calcRect() {
            this.rect.x = this.x;
            this.rect.y = this.y;
            this.rect.width = this.w;
            this.rect.height = this.h;
        }

        public void paint(Graphics g, int xoff, int yoff) {
            int xb = this.x + xoff;
            int yb = this.y + yoff;
            g.drawString(this.s, xb, yb);
            if (this.strike > 0) {
                Color save_col = g.getColor();
                g.setColor(Formel.this.strike_col);
                g.drawLine(xb, yb + this.dsc, xb + this.w, yb - this.asc);
                g.drawLine(xb, yb + this.dsc - 1, xb + this.w, yb - this.asc - 1);
                g.setColor(save_col);
            }
            if (this.ratio > 0) {
                g.drawLine(xb - 2, yb + this.dsc - 1, xb + this.w, yb + this.dsc - 1);
                g.drawLine(xb - 2, yb + this.dsc, xb + this.w, yb + this.dsc);
            }
        }
    }

    class FormelMetrics {
        FontMetrics fm;
        int h;
        int asc;
        int dsc;

        public FormelMetrics(FontMetrics fm) {
            Formel.this = Formel.this;
            this.fm = fm;
            this.h = fm.getAscent() + fm.getDescent();
            this.asc = fm.getAscent();
            this.dsc = fm.getDescent();
        }
    }

    class FormelGraph {
        FormelMetrics fom;
        String s;
        final int FEDIM = 100;
        FormelElem[] fetab = new FormelElem[100];
        int fetabn;

        public FormelGraph(String s, FontMetrics fm) {
            Formel.this = Formel.this;
            int slen = s.length();
            char[] ctab = new char[slen + 1];
            FormelElem last_fe = null;
            FormelElem[] parent_tab = new FormelElem[20];
            boolean parent_tabn = false;
            int nextx = 0;
            int nexty = 0;
            int yoff = 0;
            int xmove = 1;
            char connect = '-';
            Formel formel = Formel.this;
            formel.getClass();
            this.fom = formel.new FormelMetrics(fm);
            this.s = s;
            s.getChars(0, slen, ctab, 0);
            int i = 0;
            while (i < slen) {
                String token;
                int i2 = i + 1;
                char c = ctab[i];
                if (Character.isDigit(c)) {
                    while ("0123456789.,".indexOf(ctab[i2]) >= 0) {
                        ++i2;
                    }
                    token = s.substring(i, i2);
                    i = i2 - 1;
                } else if (Character.isLetter(c)) {
                    while (Character.isLetterOrDigit(ctab[i2])) {
                        ++i2;
                    }
                    token = s.substring(i, i2);
                    i = i2 - 1;
                } else {
                    token = s.substring(i, i + 1);
                }
                connect = '-';
                boolean elem = true;
                if (token.length() == 1) {
                    if (c == '*') {
                        token = ".";
                    } else if (c == '_') {
                        connect = c;
                        elem = false;
                        xmove = 0;
                        if (last_fe != null) {
                            yoff = last_fe.h;
                        }
                    } else if (c == '.') {
                        connect = c;
                        elem = false;
                        if (last_fe != null) {
                            yoff = last_fe.dsc + 4;
                        }
                    } else if (c == '^') {
                        connect = c;
                        elem = false;
                        if (last_fe != null) {
                            yoff = -(last_fe.dsc + 4);
                        }
                    } else if (c == '&') {
                        connect = c;
                        elem = false;
                        if (last_fe != null) {
                            last_fe.strike = 1;
                        }
                    } else if (c == '/') {
                        connect = c;
                        elem = false;
                        xmove = 0;
                        if (last_fe != null) {
                            yoff = last_fe.h;
                            last_fe.ratio = 1;
                        }
                    } else if (c == ' ') {
                        connect = '-';
                        elem = false;
                    }
                }
                if (elem) {
                    FormelElem fe;
                    Formel formel2 = Formel.this;
                    formel2.getClass();
                    this.fetab[this.fetabn++] = fe = formel2.new FormelElem(token, 'a', connect, this.fom);
                    if (xmove > 0) {
                        fe.x = nextx;
                        fe.y = nexty + yoff;
                        nextx += fe.w;
                    } else {
                        fe.x = last_fe.x;
                        fe.y = nexty + yoff;
                        xmove = 1;
                    }
                    last_fe = fe;
                    yoff = 0;
                }
                ++i;
            }
        }

        public Dimension getSize() {
            Dimension di = new Dimension();
            Rectangle rect = null;
            int i = 0;
            while (i < this.fetabn) {
                this.fetab[i].calcRect();
                Rectangle rect2 = this.fetab[i].rect;
                rect = i == 0 ? rect2 : rect.union(rect2);
                ++i;
            }
            di.width = rect.width;
            di.height = rect.height;
            return di;
        }

        public Dimension getSizeText() {
            Dimension di = new Dimension();
            di.width = this.fom.fm.stringWidth(this.s);
            di.height = this.fom.h;
            return di;
        }

        public void paint(Graphics g, int xoff, int yoff) {
            yoff += this.fom.fm.getAscent();
            int i = 0;
            while (i < this.fetabn) {
                this.fetab[i].paint(g, xoff, yoff);
                ++i;
            }
        }
    }
}

