/*
 * Decompiled with CFR 0.152.
 */
package com.hls.Geometrie;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.text.NumberFormat;

public class Geometrie
extends Applet
implements Runnable {
    Thread thread;
    Image im;
    int w;
    int h;
    int ClipBorder = 5;
    int origin_x;
    int origin_y;
    double xl;
    double xr;
    double yt;
    double yb;
    int GridSizePixel = 20;
    double GridSizeCm = 0.5;
    Color BackColor = Color.gray;
    Color GridColor = Color.red;
    Color TextColor = Color.black;
    Color KoordColor = new Color(66, 66, 66);
    Color DrawColor = Color.black;
    int gx1 = 10;
    int gy1 = 10;
    int gx2 = 10;
    int gy2 = 10;
    Font f_titel;
    Font f_def;
    int TitleHeight;
    String Title;
    String[] Input;
    static NumberFormat fmt;
    double VectorLen = 0.30000000000000004;
    double VectorWidth = 0.2;
    String DefaultBody = "Punkt M = (3 4) ";
    int paint_count;

    int CmRetPixel(double cm) {
        return (int)((double)this.GridSizePixel * cm / this.GridSizeCm);
    }

    public static String DoubleRetStringPlus(double y, int w, int d) {
        int i = w - d - 1;
        if (fmt == null) {
            fmt = NumberFormat.getInstance();
            fmt.setMinimumIntegerDigits(1);
        }
        fmt.setMaximumIntegerDigits(30);
        fmt.setMaximumFractionDigits(d);
        fmt.setMinimumFractionDigits(d);
        String s = fmt.format(y);
        return s;
    }

    public void GraphicsDrawCircleCm(Graphics g, double xcm, double ycm, double r) {
        this.GraphicsDrawPointNameCm(g, xcm, ycm, "");
        g.drawArc(this.XcmRetXpi(xcm - r), this.YcmRetYpi(ycm + r), this.CmRetPixel(2.0 * r), this.CmRetPixel(2.0 * r), 0, 360);
    }

    public void GraphicsDrawGeometrie(Graphics g) {
        boolean i = false;
        int j = -1;
        int k = -1;
        g = this.im.getGraphics();
        g.setColor(this.BackColor);
        g.fillRect(0, 0, this.w, this.h);
        this.GraphicsDrawGrid(g, 100, 100, this.GridSizePixel);
        if (this.TitleHeight > 0) {
            g.setColor(this.TextColor);
            this.GraphicsFontDrawStringCenter(g, this.f_titel, this.w / 2, 17, this.Title);
        }
        int cb = this.ClipBorder;
        g.setClip(cb, cb, this.w - 2 * cb, this.h - 2 * cb);
        g.setColor(this.KoordColor);
        this.GraphicsDrawVectorCm(g, this.xl, 0.0, this.xr - 0.5, 0.0);
        this.GraphicsDrawVectorCm(g, 0.0, this.yb, 0.0, this.yt - 0.5);
        g.setColor(this.DrawColor);
        this.GraphicsDrawPointNameCm(g, 2.0, 3.0, "C");
        this.GraphicsDrawPointNameCm(g, 1.5, 8.0, "D");
        this.GraphicsDrawPointNameCm(g, 5.0, 3.0, "E");
        this.GraphicsDrawCircleCm(g, 3.0, 3.0, 2.0);
        g.setColor(this.KoordColor);
    }

    public void GraphicsDrawGrid(Graphics g, int ori_x, int ori_y, int pixels) {
        this.gx1 = 10;
        this.gy1 = 10;
        this.gx2 = 10;
        this.gy2 = 10;
        g.setColor(this.GridColor);
        int x = this.gx1;
        while (x < this.w) {
            g.drawLine(x, 0, x, this.h - 1);
            this.gx2 = x;
            x += pixels;
        }
        int y = this.gy1;
        while (y < this.h) {
            g.drawLine(0, y, this.w - 1, y);
            this.gy2 = y;
            y += pixels;
        }
    }

    public void GraphicsDrawPointName(Graphics g, int x, int y, String name) {
        g.drawLine(x, y - 3, x, y + 3);
        g.drawLine(x - 3, y, x + 3, y);
        this.GraphicsFontDrawStringCenter(g, this.f_def, x, y, name);
    }

    public void GraphicsDrawPointNameCm(Graphics g, double xcm, double ycm, String name) {
        int x = this.XcmRetXpi(xcm);
        int y = this.YcmRetYpi(ycm);
        this.GraphicsDrawPointName(g, x, y, name);
    }

    public void GraphicsDrawRectColor(Graphics g, int gx1, int gy1, int gx2, int gy2) {
        g.drawLine(gx1, gy2, gx2, gy2);
        g.drawLine(gx1, gy2 + 1, gx2, gy2 + 1);
        g.drawLine(gx1, gy1, gx2, gy2);
        g.drawLine(gx2, gy1, gx1, gy2);
        g.drawLine(gx2 - 1, gy1, gx1, gy2 - 1);
        g.drawLine(gx2, gy1 + 1, gx1 + 1, gy2);
        g.drawLine(gx2, gy2, gx2, gy1);
        g.drawLine(gx2, gy1, gx1, gy1);
        g.drawLine(gx1, gy1, gx1, gy2);
    }

    public void GraphicsDrawVectorCm(Graphics g, double x1, double y1, double x2, double y2) {
        double vx = x2 - x1;
        double vy = y2 - y1;
        double len = Math.sqrt(vx * vx + vy * vy);
        int[] x = new int[3];
        int[] y = new int[3];
        int p3x = this.XcmRetXpi(x2);
        int p3y = this.YcmRetYpi(y2);
        x[0] = p3x;
        x[1] = p3x - 5;
        x[2] = p3x;
        y[0] = p3y;
        y[1] = p3y;
        y[2] = p3y - 5;
        g.drawLine(this.XcmRetXpi(x1), this.YcmRetYpi(y1), p3x, p3y);
        g.fillPolygon(x, y, 3);
    }

    public void GraphicsDrawVectorPixel(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    public void GraphicsFontDrawStringCenter(Graphics g, Font f, int x, int y, String s) {
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        int xlen = fm.stringWidth(s);
        int asc = fm.getAscent();
        g.drawString(s, x - xlen / 2 - 10, y + asc / 2);
    }

    double PixelRetCm(int pixel) {
        return (double)pixel * this.GridSizeCm / (double)this.GridSizePixel;
    }

    public int StrBaseRetInt(String s, int base) {
        int ret = 0;
        try {
            ret = Integer.parseInt(s, base);
        }
        catch (Exception exception) {}
        return ret;
    }

    int XcmRetXpi(double xcm) {
        return (int)((double)this.GridSizePixel * (xcm - this.xl) / this.GridSizeCm);
    }

    int YcmRetYpi(double ycm) {
        return (int)((double)this.GridSizePixel * (this.yt - ycm) / this.GridSizeCm);
    }

    String getParameter(String s, String s1) {
        if ((s = this.getParameter(s)) == null) {
            return s1;
        }
        return s;
    }

    String[] getParameterList(String s, char c) {
        String s1 = s;
        String[] as = null;
        if (s != null) {
            int i;
            boolean flag = false;
            int k = 0;
            while ((i = s1.indexOf(c)) >= 0) {
                s1 = s1.substring(i + 1);
                ++k;
            }
            if (s1.length() > 0) {
                ++k;
            }
            as = new String[k];
            s1 = s;
            int l = 0;
            while (l < as.length) {
                int j = s1.indexOf(c);
                if (j < 0) {
                    as[l] = s1.substring(0, s1.length());
                    s1 = null;
                } else {
                    as[l] = s1.substring(0, j);
                    s1 = s1.substring(j + 1);
                }
                ++l;
            }
        }
        return as;
    }

    public void init() {
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        this.origin_x = 30;
        this.origin_y = this.h - 30;
        this.xl = this.PixelRetCm(-this.origin_x);
        this.xr = this.PixelRetCm(this.w - this.origin_x);
        this.yb = this.PixelRetCm(this.origin_y - this.h);
        this.yt = this.PixelRetCm(this.origin_y);
        String body = this.getParameter("Body", this.DefaultBody);
        this.Input = this.getParameterList(body, '|');
        String ai = this.getParameter("Hintergrund", "#f3f3ff");
        this.BackColor = new Color(this.StrBaseRetInt(ai.substring(1), 16));
        ai = this.getParameter("Linierungsfarbe", "#aaaaff");
        this.GridColor = new Color(this.StrBaseRetInt(ai.substring(1), 16));
        ai = this.getParameter("Farbe", "#000000");
        this.TextColor = new Color(this.StrBaseRetInt(ai.substring(1), 16));
        this.Title = this.getParameter("Titel", "");
        this.TitleHeight = 20;
    }

    public void paint(Graphics g) {
        if (this.im == null) {
            this.f_titel = new Font("Times", 3, 16);
            this.f_def = new Font("Times", 1, 14);
            this.im = this.createImage(this.w, this.h);
            if (this.im != null) {
                this.GraphicsDrawGeometrie(this.im.getGraphics());
            }
        }
        g.drawImage(this.im, 0, 0, this);
    }

    public void run() {
        while (this.thread != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }
}

